﻿//////////////////////////////////////////////
// ProgramCompilationResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/DxDefinesWrapper.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ProgramCompilationResult final
	{
		public :

			// Constructor
			ProgramCompilationResult() noexcept ;

			// Getters
			nkMemory::StringView getErrorMessage () const ;
			SHADER_TYPE getStage () const ;	
			bool getSuccess () const ;

			// Setters
			void setErrorMessage (nkMemory::StringView message) ;
			void setStage (SHADER_TYPE value) ;	
			void setSuccess (bool value) ;
			
		private :

			// Attributes
			nkMemory::String _errorMessage ;
			SHADER_TYPE _stage ;
			bool _success ;
	} ;
}